#!/bin/sh
# \
    exec ${REPLAY_WISH-wish4.1} $0 ${1+"$@"}
#
# test1.tcl
#     This is a test program that includes all the Tk widgets.
#
# $Id: test1.tcl,v 1.4 2004/10/06 21:06:12 clif Exp $
# $Log: test1.tcl,v $
# Revision 1.4  2004/10/06 21:06:12  clif
# A readme for the new version of tkreplay.
#
# Revision 1.3  2004/10/06 20:51:16  clif
# An exercise Event script for test1.tcl
#
# Revision 1.2  2004/09/02 18:43:57  clif
# Removed need for tkreplay to have HisName, port, etc in command line
# for use with sockets.  Removed more of the "send" support.  Removed
# -UseSocket from command line.
#
# Revision 1.1.1.1  2004/03/09 15:36:16  clif
# The initial TkReplay from Crowley's website.
#
# Revision 1.2  1996/07/31  16:19:22  crowley
# This is the 1.1 revision of tjreplay.  Lots of small changes.
# Most of them from Dean Brettle.  Connecting and replay are
# faster.  Socket support has been added.
#
# Revision 1.1  1996/07/29  22:47:53  crowley
# Initial revision
#

#
# set up socket communication
#
    source socksend/socksend.tcl
    sockappsetup tktest.tcl 3010 127.0.0.1

proc tkerror {msg} {global errorInfo
    puts "ERROR(test1): $msg ==> $errorInfo"}
#
# menu
#
menubutton .menubutton -text "Menu Button" -menu .menubutton.m \
    -relief raised
pack .menubutton -side top
menu .menubutton.m
.menubutton.m add command -label Command \
    -command {puts "Command menu item picked"}
.menubutton.m add checkbutton -label "Check Button"
.menubutton.m add radiobutton -label "Radio Button A" \
    -variable menuRB -value A
.menubutton.m add radiobutton -label "Radio Button B" \
    -variable menuRB -value B
.menubutton.m invoke 3
#
# buttons
#
button .button -text Button -command {puts "Button was pushed"}
pack .button -side top -fill x
checkbutton .cbutton -text CheckButton -bd 2 -relief raised \
    -command {puts "Check button was pushed"}
pack .cbutton -side top -fill x
radiobutton .r1button -text "RadioButton 1" -bd 2 -relief raised \
    -command {puts "Radio button 1 was pushed"} -variable RB -value 1
.r1button select
pack .r1button -side top -fill x
radiobutton .r2button -text "RadioButton 2" -bd 2 -relief raised \
    -command {puts "Radio button 2 was pushed"} -variable RB -value 2
pack .r2button -side top -fill x
#
# dialog
#
button .dialogButton -text "Dialog Box" -command {
    tk_dialog .dialogBox "Dialog Box" \
        "This is an example of a dialog box" {} 0 \
        "Okay" "Cancel"
}
pack .dialogButton -side top -fill x
#
# option menu
#
tk_optionMenu .optionMenu optMenuVar \
    Sunday Monday Tuesday Wednesday Thursday Friday Saturday
pack .optionMenu -side top -fill x
#
# entry
#
entry .entry -relief sunken
pack .entry -side top -fill x
#
# scale
#
scale .scale -orient horizontal
pack .scale -side top -fill x
#
# listbox
#
frame .lb
pack .lb -side top -fill both -expand yes
scrollbar .lb.yscroll -orient vertical -command ".lb.listbox yview"
listbox .lb.listbox -width 10 -height 4 -bd 2 -relief raised \
    -yscroll ".lb.yscroll set"    
pack .lb.yscroll -side left -fill y
.lb.listbox insert 0 111 222 333 444 555 666 777 888 999
pack .lb.listbox -side right -fill both -expand yes
#
# text
#
text .text -width 10 -height 4 -bd 2 -relief raised
.text insert end {abcdef
ghijkl
mnopqr
stuvwx}
pack .text -side top -fill both -expand yes
.text tag add atag 1.1 1.4
.text tag configure atag -foreground green
.text tag bind atag <1> {.text tag configure atag -foreground purple}
.text tag bind atag <3> {.text tag configure atag -foreground green}
.text tag add btag 2.0 3.0
.text tag configure btag -foreground blue
.text tag bind btag <Enter> {.text tag configure btag -foreground red}
.text tag bind btag <Leave> {.text tag configure btag -foreground blue}
#
# canvas
#
canvas .canvas -width 180 -height 100 -bd 2 -relief raised
set r1 [.canvas create rectangle 10 10 80 40 -fill green]
set r2 [.canvas create rectangle 120 10 160 40 -fill green]
.canvas addtag rect all
.canvas bind rect <Enter> {.canvas itemconfigure current -fill yellow}
.canvas bind rect <Leave> {.canvas itemconfigure current -fill green}
set o1 [.canvas create oval 80 50 120 75 -fill blue]
.canvas bind $o1 <1> {.canvas itemconfigure current -fill red}
.canvas bind $o1 <3> {.canvas itemconfigure current -fill blue}
pack .canvas -side top -fill x
#
# quit
#
button .title -text "EXIT" -command exit
pack .title -side top

