set Release(rr.tcl) {$Header: /home/cvs/tktest/rr.tcl,v 1.7 2004/10/05 01:17:35 clif Exp $}
#
proc RecordTcl {app script} {
    global ReplayData 

  socksendDebug "INTO RecordTcl app $app script $script"
    # Only record events when the recording switch is on.

    if {!$ReplayData(RecordingOn)} {
        return
    }

    # Are we connected?
    
    if {[string equal "" $ReplayData(ConnectedApps)]} {
      tk_messageBox -type ok -message "Not connected to any application"
      return
    }
    

    # Compute the delay between this event and the last event
    # and call InsertAction to insert it into the replay list.

    set currentTime $ReplayData(Timer)
    set delay [expr $currentTime-$ReplayData(LastEventAt)]
    set ReplayData(LastEventAt) $currentTime
puts "Insert"
    InsertAction $delay $app ExecTcl $script
puts "DONE"
}

###################################################################
# RecordAction: records an action in the replay list (if recording is on).
###################################################################
proc RecordAction {app tag event replaceList} {
    global ReplayData

    # Only record events when the recording switch is on.

    if {!$ReplayData(RecordingOn)} {
        return
    }

    # Are we connected?
    
    if {[string equal "" $ReplayData(ConnectedApps)]} {
      tk_messageBox -type ok -message "Not connected to any application"
      return
    }
    

    # Compute the delay between this event and the last event
    # and call InsertAction to insert it into the replay list.

    set currentTime $ReplayData(Timer)
    set delay [expr $currentTime-$ReplayData(LastEventAt)]
    set ReplayData(LastEventAt) $currentTime
    set subscript "Bind,$tag,$event"
    InsertAction $delay $app $subscript $replaceList
}
###################################################################
# ReplayTimerTick: this is called every 100ms while recording is on.
#     It is used to record the delay between events so we can replay
#     them at the same speed they were recorded at.
###################################################################
proc ReplayTimerTick {} {
    global ReplayData
    # has the timer been turned off?
    if {$ReplayData(Timer) < 0} {
        return
    }
    incr ReplayData(Timer)
    if {$ReplayData(RecordingOn)} {
        after 100 ReplayTimerTick
    }
}
###################################################################
# MovePointerTo: this proc moves the mouse pointer to a specified
#   location.  The simplest implementation would be a single
#   WarpPointer command.  Instead we move it in a smooth motion
#   to its new location.  This makes it easier for people to follow
#   the mouse cursor.  The cursor speed can be set to several levels.
#
#   We move a little at a time, moving only in 45 degree angles or
#   up and dow.
###################################################################
#
# USER OPTION: you can modify this procedure to move the mouse in a
# different way.
#
proc MovePointerTo {x y app w} {
    global ReplayData
    # get the X id of thew window so we can send it to WarpPointer
    set wid [SendToApp $app [list winfo id $w]]
    if {$wid == ""} {
        # the window does not exists. It was probably destroyed by a
        # previous callback.
        return
    }
    if {$ReplayData(MouseSpeed) != 999} {
        # get the root x and y coordinates of the (upper left corner of)
        # the widget
        set wx  [SendToApp $app [list winfo rootx $w]]
        set wy  [SendToApp $app [list winfo rooty $w]]
        # compute the x,y coordinates to move to
        set tox [expr $wx+$x]
        set toy [expr $wy+$y]
        # find out where the point pointer is now
        set pxy [winfo pointerxy .]
        set curx [lindex $pxy 0]
        set cury [lindex $pxy 1]
        # compute the deltas and the distance
       set dx [expr $tox-$curx]
        set dy [expr $toy-$cury]
        set distance [expr round(sqrt($dx*$dx + $dy*$dy))]
        # adjust things so a single loop will go either direction
        if {$dx >= 0} {
            set xinc 1
        } else {
            set xinc -1
        }
        if {$dy >= 0} {
            set yinc 1
        } else {
            set yinc -1
        }
        # deal with the speeup factor
        set xinc [expr $ReplayData(MouseSpeed) * $xinc]
        set yinc [expr $ReplayData(MouseSpeed) * $yinc]
        # move the pointer incrementally in a loop
        while {($dx != 0) || ($dy != 0)} {
            # figure out how much to move in the x and y directions
            if {$dx != 0} {
                # do not go too far
                if {abs($xinc) > abs($dx)} {
                    set xinc $dx
                }
                set relx $xinc
                set dx [expr $dx - $xinc]
            } else {
                set relx 0
            }
            if {$dy != 0} {
                if {abs($yinc) > abs($dy)} {
                    set yinc $dy
                }
                set rely $yinc
                set dy [expr $dy - $yinc]
            } else {
                set rely 0
            }
            WarpPointer $relx $rely 0
            update
        }
    }
    WarpPointer $x $y $wid
}
###################################################################
# MovePointerTo: this proc moves the mouse pointer to a specified
#   location.  The simplest implementation would be a single
#   WarpPointer command.  Instead we move it in a smooth motion
#   to its new location.  This makes it easier for people to follow
#   the mouse cursor.
#
#   We move a little at a time, moving in a diagonal line from the
#   starting point to the stopping point.
#   There is an option to move faster.
###################################################################
proc NewMovePointerTo {x y app w} {
#
# Doesn't work yet.  Finish it later.
#
    global ReplayData
    # get the X id of thew window so we can send it to WarpPointer
    set wid [SendToApp $app [list winfo id $w]]
    # get the root x and y coordinates of the (upper left corner of) the widget
    set wx  [SendToApp $app [list winfo rootx $w]]
    set wy  [SendToApp $app [list winfo rooty $w]]
    # compute the x,y coordinates to move to
    set tox [expr $wx+$x]
    set toy [expr $wy+$y]
    # find out where the point pointer is now
    set pxy [winfo pointerxy .]
    set fromx [lindex $pxy 0]
    set fromy [lindex $pxy 1]
    # compute the deltas, the distance and the slope of the line between them
    set dx [expr $tox-$fromx]
    set dy [expr $toy-$fromy]
    set distance [expr round(sqrt(double($dx*$dx + $dy*$dy)))]
    set slope [expr double($dx)/double($dy)]
    # figure out the sign of the increment
    if {$dx < 0} {
        set xinc -1
    } else {
        set xinc 1
    }
    # handle the speedup factor
    set speedup 5
    if {$ReplayData(moveMouseQuickly)} {
        set xinc [expr $speedup * $xinc]
    }
    set curx $fromx
    set cury $fromy
    for {set i 0} {$i < $dx} {incr i} {
        set x [expr $fromx + $i*$xinc]
        set relx [expr $x - $curx]
        set curx $x
        set y [expr round($fromy + double($i)/$slope)]
        set rely [expr $y - $cury]
        set cury $y
        WarpPointer $relx $rely 0
        update
    }
    WarpPointer $x $y $wid
}
###################################################################
# ReplayActions: this proc plays the recorded actions starting at the
#   current action.  This means that you must rewind to play all
#   the actions.  Or you can start anywhere in the recording.
###################################################################
proc ReplayActions {} {
    global ReplayData
    global GUI
    
    # Are we connected?
    
    if {[string equal "" $ReplayData(ConnectedApps)]} {
      tk_messageBox -type ok -message "Not connected to any application"
      return
    }

    # If we are pointing with a window, make the window visible

    if {$ReplayData(pointWithArrow)} {
       GetReplayPointer
       set lastPointerX  -1
       set lastPointerY  -1
    }

    # Make the binding for CatchClicks in each connected application.
    # This will allow the user to stop the replay in the middle with
    # a mouse button click or by pressing Escape.  Since the replay takes
    # control of the mouse, this may be the only way to stop a replay.
    # Also set the flag in the target telling it that we are currently
    # replaying a script.  This will cause it to ignore most input.
    #
    #
    # USER OPTION: you can change the events that cause the replay to pause.
    # Just change "<1>" and "<Escape>" below to other user actions.

    foreach app $ReplayData(ConnectedApps) {
        SendToApp $app [list bind__rd CatchClicks <1> \
            {catch [list tkrsend $db__rd(ReplayApp) RemoteInput Button]}]
        SendToApp $app [list bind__rd CatchClicks <Escape> \
            {catch [list tkrsend $db__rd(ReplayApp) RemoteInput Escape]}]
        SendToApp $app [list set db__rd(Replaying) 1]
    }
    set level 0
    #
    # Loop through the events and replay them.
    #
    while 1 {
        #
        # If user has pressed Stop (or clicked) then quit playing
        #
        if !$ReplayData(PlayingOn) {
            break
        }
        #
        # move to the next action to replay
        #
        set index $ReplayData($level,ScriptIndex)
        incr ReplayData($level,ScriptIndex)
        set action [lindex $ReplayData($level,Script) $index]

        #
        # Select the event we are playing
        # so that it is highlighted in the event list.
        #
        SelectActionListItem $index middle
        #
        # Wait for the delay period (if delay is greater than 0).
        #
        set delay [lindex $action 0]
        if {$delay > 0} {
            if $ReplayData(UseDelays) {
                after [expr 100*$delay]
            }
        }
        #
        # Get the data on the event
        #
        set app [lindex $action 1]
        set subscript [lindex $action 2]
        set replaceList [lindex $action 3]

        update idle;

        #
        # Check for the commands handled here.
        # Other commands are handled in the target application.
        #
        #
        # USER OPTION: you can add new pseudo-events here.  You will also
        # have to add menu items that will place these events in scripts
        # when you are recording.
        #


        switch -- $subscript \
            Pause {
                SelectActionListItem $ReplayData($level,ScriptIndex) see
                MsgToUser "Script replay was paused"
                break
            } \
            "--- Beginning of script ---" {
                MsgToUser "Start script"
                continue
            } \
            "--- End of script ---" {
                MsgToUser "End of script"
                if {$ReplayData(Level) == 0} {
                    break
                }
                incr ReplayData(Level) -1
                incr level -1
                $GUI(eventlistbox) delete 0 end
                foreach event $ReplayData($level,Script) {
                    set delay [lindex $event 0]
                    set subscript [lindex $event 2]
                    set replaceList [lindex $event 3]
                    $GUI(eventlistbox) insert end \
                        [FormatEvent $delay $subscript $replaceList]
                }
                SelectActionListItem $ReplayData($level,ScriptIndex) see
                continue
            } \
            ExecScript {
                incr ReplayData(Level)
                incr level
                set ReplayData($level,Script)       {}
                set ReplayData($level,ScriptIndex)  0
                set ReplayData($level,ScriptFileName) $replaceList
                LoadScript $replaceList
                continue
            } \
            ExecTcl {
                set tclScript [lindex $replaceList 0]
                set execInReplay [lindex $replaceList 1]
                if $execInReplay {
                    eval $tclScript
                } else {
                    foreach app $ReplayData(ConnectedApps) {
                        SendToApp $app $tclScript
                    }
                }
                continue
            } \
            LoadApp {
                LoadApp $replaceList
                continue
            } \
            ConnectToApp {
                ConnectToApp [lindex $replaceList 0]
                continue
            } \
            BeginComment {
                MakeComment [lindex $replaceList 0] [lindex $replaceList 1] \
                    [lindex $replaceList 2]
                continue
            } \
            EndComment {
                catch [list destroy [format {.comment%s} $replaceList]]
                continue
            }
        #
        # parse the subscript to get the widget and event
        #
        set event ""
        regexp {Bind,([^,]*),(.*)} $subscript what which event
        #
        # Get the widget name
        #
        set w [rrlookup W $replaceList]
        #
        # do special processing on some events
        #
        #
        # USER OPTION: If you do not want the mouse pointer to change to
        # show button down and button up then eliminate this switch.
        #
        if $ReplayData(pointWithMouse) {
            switch -glob -- $event \
                "*<Button-1>*" {
                    set ReplayData(OldCursor) [SendToApp $app \
                        [list . configure -cursor leftbutton]]
                    update
                } \
                "*<Button-2>*" {
                   set ReplayData(OldCursor) [SendToApp $app \
                       [list . configure -cursor middlebutton]]
                    update
                } \
                "*<Button-3>*" {
                    set ReplayData(OldCursor) [SendToApp $app \
                       [list . configure -cursor rightbutton]]
                    update
                } \
                "*<ButtonRelease-1>*" - \
                "*<ButtonRelease-2>*" - \
                "*<ButtonRelease-3>*" {
                    SendToApp $app \
                        [list . configure -cursor $ReplayData(OldCursor)]
                    update
                }
        }
        #
        # see if we should move the mouse or pointing window to this event
        #
        #
        # USER OPTION: you can place other connditions on whether an event
        # is shown or not.
        #
        set pointToWidget 1
        switch -- $event \
            "<Configure>" - \
            "<FocusIn>"   - \
            "<FocusOut>" {
                set pointToWidget 0
            }
        #
        # Move the pointer window (if that option is on)
        #
        if {$pointToWidget && $ReplayData(pointWithArrow) && $w!={}} {
            set rootx [SendToApp $app [list winfo rootx $w]]
            set rooty [SendToApp $app [list winfo rooty $w]]
            set x [expr $rootx-56]; if {$x<0} {set x 0}
            set y [expr $rooty-25]; if {$y<0} {set y 0}
            if {$x != $lastPointerX || $y != $lastPointerY} {
                wm geometry .replaypointer "+$x+$y"
                raise .replaypointer
                update
                set lastPointerX $x
                set lastPointerY $y
            }
        }
        #
        # Move the mouse pointer (if that option is on)
        #
        if {$ReplayData(pointWithMouse)
         && $pointToWidget
         && $w != {}} {
            set x [rrlookup x $replaceList]
            if {$x == ""} {
                 set x 5
            }
            set y [rrlookup y $replaceList]
            if {$y == ""} {
                 set y 5
            }
            MovePointerTo $x $y $app $w
        }
        #
        # Assign a unique identifier to the action.  This is necessary
        # so we can identify which action has completed (or timed out)
        # when we get a reply message from the target application.
        #
        set uid [GetUniqueID]
        #
        # Figure out the maximum time to wait for the event handler to
        # complete.  Some event handlers call tkwait and so may not
        # return for a long time.
        #(
        set nextDelay \
            [lindex [lindex $ReplayData($level,Script) [expr $index+1]] 0]
        if {$nextDelay == ""} {
            set nextDelay 0
        }
        #
        # give a little extra time for the timeout, 1 second
        #
        set timeout [expr $nextDelay+1000]
        #
        # Send the command to the remote application to execute
        # the binding for this event.  The tcl scripts to execute
        # are stored in the remote application.  We only store the
        # widget name and the event name.
        # We send it asynchronously because we are waiting for a
        # replay message anyway (in the tkwait after the send).
        #
        SendToApp $app [format {ReplayAction {%s} {%s} {%s} {%s}} \
                $uid $timeout $subscript $replaceList] asyncronous
        set ReplayData(PendingCommandUID) $uid
        tkwait variable ReplayData(CommandDone)
        update
    }
    foreach app $ReplayData(ConnectedApps) {
        SendToApp $app [list bind__rd CatchClicks <1> {#}]
        SendToApp $app [list bind__rd CatchClicks <Escape> {#}]
        SendToApp $app [list set db__rd(Replaying) 0]
    }
    if {$ReplayData(pointWithArrow)} {
        wm withdraw .replaypointer
    }
}
###################################################################
# SelectActionListItem: select an item in the list of actions and
#  make sure that it can be seen.
###################################################################
proc SelectActionListItem {index {how see}} {
    global GUI

    set lb $GUI(eventlistbox)
    if {$how == "see"} {
        $lb see $index
    } else { # place it in the middle of the list box
        set height [$lb cget -height]
        set top [expr $index - ($height/2)]
        if {$top < 0} {
            set top 0
        }
        $lb yview $top
    }
    $lb selection clear 0 end
    $lb selection set $index
}
###################################################################
# SelectAndSetItem: callback for a select click in the list box
#   that show the actions.
###################################################################
proc SelectAndSetItem {listbox x y} {
    global ReplayData
    set index [$listbox index @$x,$y]
    set ReplayData($ReplayData(Level),ScriptIndex) $index
    SelectActionListItem $index
}
###################################################################
# GetUniqueID: generate a unique identifier.
###################################################################
proc GetUniqueID {} {
    global ReplayData
    set uid $ReplayData(UIDCounter)
    incr ReplayData(UIDCounter)
    return $uid
}
###################################################################
# ActionEnd: called only from a "send" from the remote application.
#   It is called when the action is completed or it times out.
#   We get two replies from each action, one from the timeout
#   and one from the action command completion.  We ignore any
#   old action completions that some and and wait for the completion
#   (or timeout) of the current action.
###################################################################
proc ActionEnd {uid how} {
    global ReplayData
    if {$uid == $ReplayData(PendingCommandUID)} {
        set ReplayData(CommandDone) 1
    }
}
###################################################################
# RemoteInput: an input event from the remote application
###################################################################
proc RemoteInput {input} {
    global ReplayData
    switch -- $input \
        Escape - \
        Button {
            set ReplayData(PlayingOn) 0
            MsgToUser "Script replay terminated by Escape or button click" low
        } \
        default {
            MsgToUser "Input $input ignored during replay" info
        }
}
###################################################################
# rrlookup: lookup a %-character in the association list.
#     The format of "alist" is:
#         { {A a-string} {B b-string} ...}
###################################################################
proc rrlookup {item alist} {
    foreach pair $alist {
        if {[string compare $item [lindex $pair 0]]==0} {
            return [lindex $pair 1]
        }
    }
    return ""
}
###################################################################
# GetReplayPointer: creates or deiconifies the big pointer we use to
#     point out the widget where the event is happening.
###################################################################
proc GetReplayPointer {} {
    #
    # USER OPTION: you can change the look of this pointer.
    #
    set w .replaypointer
    if [winfo exists $w] {
        wm deiconify $w
    } else {
        toplevel $w
        wm geometry $w "+0+0"
        wm overrideredirect $w 1
        canvas $w.canvas -width 50 -height 50 -background white
        $w.canvas create line 0 25 50 25 -width 20 -arrow last \
            -fill red -arrowshape {25 40 15}
        pack $w.canvas
    }
}


proc RebuildActions {} {
    global ReplayData
    global GUI
    
    # Are we connected?
    
    set filename [tk_getSaveFile -defaultextension .tkr \
        -filetypes {{{TkReplay Files} .tkr} {Script .scr} {tcl {.tcl .tk}}} \
	-initialdir $ReplayData(scriptFileDir)]

    if {$filename == ""} {
        MsgToUser "Save cancelled"
        return
    }

    set of [open $filename w]

    if {[string equal "" $ReplayData(ConnectedApps)]} {
      tk_messageBox -type ok -message "Not connected to any application"
      return
    }

    # If we are pointing with a window, make the window visible

    if {$ReplayData(pointWithArrow)} {
       GetReplayPointer
       set lastPointerX  -1
       set lastPointerY  -1
    }

    # Make the binding for CatchClicks in each connected application.
    # This will allow the user to stop the replay in the middle with
    # a mouse button click or by pressing Escape.  Since the replay takes
    # control of the mouse, this may be the only way to stop a replay.
    # Also set the flag in the target telling it that we are currently
    # replaying a script.  This will cause it to ignore most input.
    #
    #
    # USER OPTION: you can change the events that cause the replay to pause.
    # Just change "<1>" and "<Escape>" below to other user actions.

    foreach app $ReplayData(ConnectedApps) {
        SendToApp $app [list bind__rd CatchClicks <1> \
            {catch [list tkrsend $db__rd(ReplayApp) RemoteInput Button]}]
        SendToApp $app [list bind__rd CatchClicks <Escape> \
            {catch [list tkrsend $db__rd(ReplayApp) RemoteInput Escape]}]
        SendToApp $app [list set db__rd(Replaying) 1]
    }
    set level 0
    #
    # Loop through the events and replay them.
    #
    while 1 {
        #
        # If user has pressed Stop (or clicked) then quit playing
        #
        if !$ReplayData(PlayingOn) {
            break
        }
        #
        # move to the next action to replay
        #
        set index $ReplayData($level,ScriptIndex)
        incr ReplayData($level,ScriptIndex)
        set action [lindex $ReplayData($level,Script) $index]

        #
        # Select the event we are playing
        # so that it is highlighted in the event list.
        #
        SelectActionListItem $index middle
        #
        # Wait for the delay period (if delay is greater than 0).
        #
        set delay [lindex $action 0]
        if {$delay > 0} {
            if $ReplayData(UseDelays) {
                after [expr 100*$delay]
            }
        }
        #
        # Get the data on the event
        #
        set app [lindex $action 1]
        set subscript [lindex $action 2]
        set replaceList [lindex $action 3]

        update idle;

        #
        # Check for the commands handled here.
        # Other commands are handled in the target application.
        #
        #
        # USER OPTION: you can add new pseudo-events here.  You will also
        # have to add menu items that will place these events in scripts
        # when you are recording.
        #
	
	# If it's not ExecTcl, we can just save it, or end/beginning

        switch -- $subscript {
            "--- Beginning of script ---" -
            "--- End of script ---" -
            ExecTcl {
	    } 
	    default {
                puts $of [eval list InsertAction $action]
	    }
        }

        switch -- $subscript \
            Pause {
                SelectActionListItem $ReplayData($level,ScriptIndex) see
                MsgToUser "Script replay was paused"
                break
            } \
            "--- Beginning of script ---" {
                MsgToUser "Start script"
                continue
            } \
            "--- End of script ---" {
                MsgToUser "End of script"
                if {$ReplayData(Level) == 0} {
                    break
                }
                incr ReplayData(Level) -1
                incr level -1
                $GUI(eventlistbox) delete 0 end
                foreach event $ReplayData($level,Script) {
                    set delay [lindex $event 0]
                    set subscript [lindex $event 2]
                    set replaceList [lindex $event 3]
                    $GUI(eventlistbox) insert end \
                        [FormatEvent $delay $subscript $replaceList]
                }
                SelectActionListItem $ReplayData($level,ScriptIndex) see
                continue
            } \
            ExecScript {
                incr ReplayData(Level)
                incr level
                set ReplayData($level,Script)       {}
                set ReplayData($level,ScriptIndex)  0
                set ReplayData($level,ScriptFileName) $replaceList
                LoadScript $replaceList
                continue
            } \
            ExecTcl {
                set tclScript [lindex $replaceList 0]
                set execInReplay [lindex $replaceList 1]
                if $execInReplay {
		    set arg [lindex $tclScript 1]
		    switch [lindex $tclScript 0] {
		      CheckReturn {
                         set xx [getReply $arg ]
			 puts $of [list InsertAction [lindex $action 0] $app \
			   $subscript \
			   [list [list CheckReturn $arg $xx] $execInReplay]]
		      }
		      CheckWinReturn {
                         set xx [getContents $arg ]
			 puts $of [list InsertAction [lindex $action 0] $app \
			   $subscript \
			   [list [list CheckWinReturn $arg $xx] $execInReplay]]
		      }
		      default {
                         puts $of [eval list InsertAction $action]
		      }
		    }
                    eval $tclScript
                } else {
                    foreach app $ReplayData(ConnectedApps) {
                        SendToApp $app $tclScript
                    }
                }
                continue
            } \
            LoadApp {
                LoadApp $replaceList
                continue
            } \
            ConnectToApp {
                ConnectToApp [lindex $replaceList 0]
                continue
            } \
            BeginComment {
                MakeComment [lindex $replaceList 0] [lindex $replaceList 1] \
                    [lindex $replaceList 2]
                continue
            } \
            EndComment {
                catch [list destroy [format {.comment%s} $replaceList]]
                continue
            }
        #
        # parse the subscript to get the widget and event
        #
        set event ""
        regexp {Bind,([^,]*),(.*)} $subscript what which event
        #
        # Get the widget name
        #
        set w [rrlookup W $replaceList]
        #
        # do special processing on some events
        #
        #
        # USER OPTION: If you do not want the mouse pointer to change to
        # show button down and button up then eliminate this switch.
        #
        if $ReplayData(pointWithMouse) {
            switch -glob -- $event \
                "*<Button-1>*" {
                    set ReplayData(OldCursor) [SendToApp $app \
                        [list . configure -cursor leftbutton]]
                    update
                } \
                "*<Button-2>*" {
                   set ReplayData(OldCursor) [SendToApp $app \
                       [list . configure -cursor middlebutton]]
                    update
                } \
                "*<Button-3>*" {
                    set ReplayData(OldCursor) [SendToApp $app \
                       [list . configure -cursor rightbutton]]
                    update
                } \
                "*<ButtonRelease-1>*" - \
                "*<ButtonRelease-2>*" - \
                "*<ButtonRelease-3>*" {
                    SendToApp $app \
                        [list . configure -cursor $ReplayData(OldCursor)]
                    update
                }
        }
        #
        # see if we should move the mouse or pointing window to this event
        #
        #
        # USER OPTION: you can place other connditions on whether an event
        # is shown or not.
        #
        set pointToWidget 1
        switch -- $event \
            "<Configure>" - \
            "<FocusIn>"   - \
            "<FocusOut>" {
                set pointToWidget 0
            }
        #
        # Move the pointer window (if that option is on)
        #
        if {$pointToWidget && $ReplayData(pointWithArrow) && $w!={}} {
            set rootx [SendToApp $app [list winfo rootx $w]]
            set rooty [SendToApp $app [list winfo rooty $w]]
            set x [expr $rootx-56]; if {$x<0} {set x 0}
            set y [expr $rooty-25]; if {$y<0} {set y 0}
            if {$x != $lastPointerX || $y != $lastPointerY} {
                wm geometry .replaypointer "+$x+$y"
                raise .replaypointer
                update
                set lastPointerX $x
                set lastPointerY $y
            }
        }
        #
        # Move the mouse pointer (if that option is on)
        #
        if {$ReplayData(pointWithMouse)
         && $pointToWidget
         && $w != {}} {
            set x [rrlookup x $replaceList]
            if {$x == ""} {
                 set x 5
            }
            set y [rrlookup y $replaceList]
            if {$y == ""} {
                 set y 5
            }
            MovePointerTo $x $y $app $w
        }
        #
        # Assign a unique identifier to the action.  This is necessary
        # so we can identify which action has completed (or timed out)
        # when we get a reply message from the target application.
        #
        set uid [GetUniqueID]
        #
        # Figure out the maximum time to wait for the event handler to
        # complete.  Some event handlers call tkwait and so may not
        # return for a long time.
        #(
        set nextDelay \
            [lindex [lindex $ReplayData($level,Script) [expr $index+1]] 0]
        if {$nextDelay == ""} {
            set nextDelay 0
        }
        #
        # give a little extra time for the timeout, 1 second
        #
        set timeout [expr $nextDelay+1000]
        #
        # Send the command to the remote application to execute
        # the binding for this event.  The tcl scripts to execute
        # are stored in the remote application.  We only store the
        # widget name and the event name.
        # We send it asynchronously because we are waiting for a
        # replay message anyway (in the tkwait after the send).
        #
        SendToApp $app [format {ReplayAction {%s} {%s} {%s} {%s}} \
                $uid $timeout $subscript $replaceList] asyncronous
        set ReplayData(PendingCommandUID) $uid
        tkwait variable ReplayData(CommandDone)
        update
    }
    close $of

    foreach app $ReplayData(ConnectedApps) {
        SendToApp $app [list bind__rd CatchClicks <1> {#}]
        SendToApp $app [list bind__rd CatchClicks <Escape> {#}]
        SendToApp $app [list set db__rd(Replaying) 0]
    }
    if {$ReplayData(pointWithArrow)} {
        wm withdraw .replaypointer
    }
}

